package mole.entities.triggers 
{
	import mole.entities.CPlayer;
	import mole.entities.controlers.CLadderControler;
	import net.flashpunk.utils.Input;
	
	/**
	 * Trigger d'échelle
	 * @author Cédric Liaudet
	 */
	public class CLadder extends CTrigger
	{
		/**
		 * Constructeur par défaut
		 * @param	_bOnce flag pour indiquer si on doit jouer le trigger qu'une seul fois
		 * @param	_Func Callback quand le trigger est activé
		 * @param	_aTypes Types accepter pour l'activation.
		 * @param	_iWith Largeur du trigger
		 * @param	_iHeight Hauteur du trigger.
		 */
		public function CLadder(_bOnce:Boolean, _Func:Function, _aTypes:Array, _iWith:int, _iHeight:int) 
		{
			super(_bOnce, OnActivated, _aTypes, _iWith, _iHeight);
		}
		
		/**
		 * MAJ du trigger.
		 */
		override public function update():void
		{
			super.update();
			
			if (!m_Entity && m_Player)
			{
				m_Player.ReleaseExternalControler();
				m_Player.OnFall();
				m_Player = null;
			}
			else if (m_Entity && Input.pressed("active"))
			{
				m_Player = m_Entity as CPlayer;
				
				// On change de controlleur.
				m_Player.SetExternalControler(new CLadderControler(this));
			}
		}
		
		/**
		 * Callback lors de l'activation.
		 */
		public function OnActivated():void
		{				
		}
		
		private var m_Player:CPlayer; ///< Le joueur qui utilise l'échelle.
	}

}